#include <bits/stdc++.h>

using namespace std;

#define xx first
#define yy second
typedef pair<double, double> pdd;

const double EPS = 1.0e-6;

double dist(pdd a, pdd b) {
  double dx = a.xx - b.xx;
  double dy = a.yy - b.yy;
  return sqrt(dx*dx + dy*dy);
}

bool contains(const vector<pdd>& towers, pdd pt, double r) {
  for (pdd tower : towers) {
    if (dist(tower, pt) > r)
      return false;
  }
  return true;
}

vector<pdd> intersections(pdd c1, pdd c2, double r) {
  double d = dist(c1, c2);
  if (d > r+r) return {};
  double h = sqrt(r*r - d*d/4);
  double x0 = c1.xx, y0 = c1.yy;
  double x1 = c2.xx, y1 = c2.yy;
  double x2 = (c1.xx + c2.xx) / 2;
  double y2 = (c1.yy + c2.yy) / 2;
  pdd p1 = { x2 + h * (y1 - y0) / d, y2 - h * (x1 - x0) / d };
  pdd p2 = { x2 - h * (y1 - y0) / d, y2 + h * (x1 - x0) / d };
  return {p1, p2};
}

bool solve(const vector<pdd>& towers, double r) {
  int n = towers.size();
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < n; j++) {
      if (i == j) continue;
      auto pts = intersections(towers[i], towers[j], r);
      if (pts.empty()) return false;
      bool possible = true;
      for (pdd p : pts) {
        for (int k = 0; k < n; k++) {
          if (k == i || k == j) continue;
          possible &= dist(towers[k], p) <= r;
        }
        if (possible) return true;
      }
    }
  }
  return false;
}

int main() {
  int n; double r;
  cin >> n >> r;
  vector<pdd> towers(n);
  for (int i = 0; i < n; i++) {
    cin >> towers[i].xx >> towers[i].yy;
  }
  bool f1 = solve(towers, 2 * (r + EPS));
  bool f2 = solve(towers, 2 * (r - EPS));
  if (f1 != f2) return -1;
  cout << (f1 ? "possible\n" : "impossible\n");
}
